/*
 * CharlieP.h
 *
 * Created: 10.12.2022 22:30:57
 *  Author: Tim Fischer 
 */ 


#ifndef CHARLIEP_H_
#define CHARLIEP_H_

//Makros for bit manipulation
#define SET_BIT(BYTE, BIT)		((BYTE) |= (1<<BIT))							// set    single BIT in BYTE
#define CLR_BIT(BYTE, BIT)		((BYTE) &= ~(1<<BIT))							// clear  single BIT in BYTE
#define CHG_BIT(BYTE, BIT, VAL) ((BYTE) = ((BYTE) & ~(1<<BIT)) | (VAL<<BIT))	// change single BIT in BYTE to VAL
#define TGL_BIT(BYTE, BIT)		((BYTE) ^=  (1 << (BIT)))						// toggle single BIT in BYTE


#define PIN_COUNT		12														// overall number of pins used
#define PORT_COUNT		3														// number of ports used

enum	PORTS	{PORT_B, PORT_C, PORT_D, DDR_B, DDR_C, DDR_D};					// in this example three different Ports are used for output. This can also be change to more or less
enum	P		{    PB,     PC,     PD};										// In this case, the matrizes outputPort, outputPin and portMatrix have to be adapted

#define DONE			1														// return value for finished round over all anodes 

//function prototypes
extern  uint8_t CharlieP_setPortsForLightingLeds(void);
extern void     CharlieP_setPortMatrix(void);

extern uint8_t outputMatrixXY	[PIN_COUNT]		[PIN_COUNT-1];
extern uint8_t portMatrix		[PORT_COUNT*2]	[PIN_COUNT];

#endif /* CHARLIEP-H_H_ */