/*
 * main.c for Charlie Plexing Demo
 *
 * 
 * Author : Tim Fischer
 *
 */ 

#include <avr/io.h>											// lib for I/O config
#include <stdbool.h>										// lib for Bit variables
#include <avr/interrupt.h>									// lib for standard interrupts
#include "charlieP.h"										// lib for charlie Plexing
#include "main.h"											// lib for maib

int main(void)
{
    TCCR0A = 0;												// set Timer 0 on "Normal Mode"
    TCCR0B |= (1<<CS01);									// activate Prescaler /8 
    TIMSK0 |= (1<<TOIE0);									// activate Overflow interrupt 
	sei();													// activate general interrupts
	
	SET_BIT(DDRD,PD1);
	while (1) 
    {
		if (cycle10msActive == 1)							 // check for 10ms cycle
		{			
			cycle10msActive = 0;								// reset 10ms cycle flag	
			if(CharlieP_setPortsForLightingLeds() == DONE)		// set Ports. Then check if all ports are cycled
			{													// when all ports are cycled:
				updateInternalMatrix();							// read in new internal matrix (matrix to be displayed)
				CharlieP_setPortMatrix();							// calculate the port matrix
			}
		}			
    }
	return 0;
}

/********************************************************************* 
 *
 * updateInternalMatrix 
 *
 * - refreshes the matrix which reflects the hardware LED-matrix 
 * - the current implementation is just activating more and more LEDs for visualisation 
 *
 *********************************************************************/
inline void updateInternalMatrix()
{
	static uint8_t colNrLED=0, rowNrLED=0;
	
	outputMatrixXY[colNrLED][rowNrLED] = 1;								//set one LED in Matrix

	colNrLED++;															// count up column 
	if (colNrLED==PIN_COUNT)											// if max column reached
	{
		colNrLED=0;															// restart in first (= 0) column 
		rowNrLED++;															// but count up row
		if (rowNrLED==PIN_COUNT-1)											// if max row reached
		{
			rowNrLED=0;															//  restart in first (= 0) row, too
			for		(uint8_t rowNr = 0; rowNr < PIN_COUNT	; rowNr++)			// loops over all rows 
				for	(uint8_t colNr = 0; colNr < PIN_COUNT-1	; colNr++)			//			  and columns
					outputMatrixXY[colNr][rowNr] = 0;								//reset all matrix elements
		}
	};
}

/********************************************************************* 
 *
 * TIMER0_OVF_vect 
 *
 * - Timer interrupt service routine for supplying the cycles
 *
 *********************************************************************/
ISR (TIMER0_OVF_vect)
{											
	--softwarePrescaler;                    
	if(softwarePrescaler==0)                // when prescaler was count down to minimum: 10ms are over
	{
		softwarePrescaler = SW_PRESCALER_VAL;	// reset prescaler
		cycle10msActive = 1;					// set cycle flag for 10ms
		--cycle10msCount;						// decrement 10ms-counter for 100ms cycle
		
		if (cycle10msCount==0)						// when 10ms-counter was count down to minimum: 100ms are over
		{
			cycle10msCount = CYCLE10MS_MAX;			// reset 10ms-counter 
			cycle100msActive = 1;					// set cycle flag for 100ms
		}
	}
}
