/*
 * main.h
 *
 * Created: 10.12.2022 23:01:16
 *  Author: Tim Fischer
 */ 


#ifndef MAIN_H_
#define MAIN_H_

#define F_CPU 8000000UL												// ATmega 328 with internal 8MHz Quarz 

//Constants
#define SW_PRESCALER_VAL		60									// software prescaler, for minimum timerticks (60 for 8kHz)
#define CYCLE10MS_MAX			10									// max value of timerticks for 10ms cycle

bool			timertick;											// bit-flag for each 0,111ms (on interrupt)
bool			cycle10msActive;									// bit-flag for each 10ms
bool			cycle100msActive;									// bit-flag for each 100ms

unsigned char	softwarePrescaler	= SW_PRESCALER_VAL;				// counting variable for prescaler
unsigned char	cycle10msCount		= CYCLE10MS_MAX;				// counting variable for 10ms

//function prototypes
void updateInternalMatrix(void);

#endif /* MAIN_H_ */