/* ----------------------------------------------------------------------------
  
 Experiment 10:   I2C Kommunikation
 =============    ===============================
  
 Dateiname		: I2C_SimpleMaster.c
   
 Autoren		: Tim Fischer       (Hochschule Heilbronn, Fakultaet TE)
                
 Datum			: 18.11.2023
   
 Version		: 1.1
   
 Hardware		: Simulide 1.0.0 >R810
  
 Software		: Entwicklungsumgebung: AtmelStudio 7.0
				  C-Compiler: AVR/GNU C Compiler 5.4.0
  
 Funktion		: einfacher I2C Master, der Schalterwerte bertrgt
  
 Displayanzeige	: keine
  
 Tastenfunktion	: Die Tastenstellung der Dip-Schalter an Port B werden als Wert ber I2C weitergegeben.
				  Dabei zhlt ein gedrckter Schalter (= hellgrn) als logisches High Signal
  
 Jumperstellung	: keine
  
 Fuses im uC	: keine
   
// ----------------------------------------------------------------------------*/
  
// Deklarationen ==============================================================
  
// Festlegung der Quarzfrequenz
#define F_CPU 8000000UL									// CPU Frequenz von 8MHz
#define F_SCL   100000L									// Baudrate von 100 kHz
 
// Include von Header-Dateien
#include <avr/interrupt.h>
#include <util/delay.h>
 
// Konstanten
#define SET_BIT(BYTE, BIT)  ((BYTE) |=  (1 << (BIT)))	// Bit Zustand in Byte setzen
#define CLR_BIT(BYTE, BIT)  ((BYTE) &= ~(1 << (BIT)))	// Bit Zustand in Byte loeschen
#define TGL_BIT(BYTE, BIT)  ((BYTE) ^=  (1 << (BIT)))	// Bit Zustand in Byte wechseln (toggle)
 
#define SET_ALL_PULLUPS		(0xFF)						// Konstante fr die Aktivierung der Pullup
#define INVERING_MASK		(0xFF)						// Konstante fr die invertierung der Schalterstellungen
#define TWI_ADRESS			(0b0001010)					// Konstante fr die I2C Adresse 

//Funktionsprototypen
void I2C_Init();
void I2C_transmitStart();
void I2C_transmitDataOrAddress(char Data);
void I2C_transmitStop();
 
uint8_t TWI_Address =  TWI_ADRESS;						// Variable der I2C Adresse 						
uint8_t TWI_Data    = 0b00000000;						// Variable fr die I2C Daten
 
 
int main(void)
{
	PORTB = SET_ALL_PULLUPS;							// Pull-up Widerstnde an Port B aktivieren
    while (1)										
    {
        I2C_Init();										// Initialisierung von TWI anstoen
        I2C_transmitStart();							// Startbit schreiben
        I2C_transmitDataOrAddress((TWI_Address<<1) + 0);// Adresse senden: LSB = 0, zeigt Slave an, dass dieser nur empfangen soll
		TWI_Data = PINB^INVERING_MASK;					// Lese Tasterstellungen ein. Invertiere jedes Bit
        I2C_transmitDataOrAddress(TWI_Data);			// Daten senden
        I2C_transmitStop();								// Stoppbit schreiben
		_delay_us(1);									// erst durch den Delay ist ein Triggern im Simulide mglich 
    }
}
 
/////////////////////////////////////////
// I2C Initialisierung
/////////////////////////////////////////
void I2C_Init()
{
    CLR_BIT(TWSR, TWPS0);								// Es wird kein Prescaler verwendet: 
    CLR_BIT(TWSR, TWPS1);								//		Deshalb TWPS0 = 0 und TWPS1 = 0
    TWCR = 0;                   						// Control Register zurcksetzen
    TWBR = ((F_CPU/F_SCL)-16)/2;						// die Bitrate wird mittels CPU Frequenz und Serial Clock Frequenz ermittelt
}
 
/////////////////////////////////////////
// I2C Startbit senden
/////////////////////////////////////////
void I2C_transmitStart()
{
    TWCR = (1<<TWINT)|(1<<TWEN)|(1<<TWSTA);				// TWSTA = Startbit aktivieren, TWEN = TWI starten (ENable), TWINT = Interrupt bit lschen (durch beschreiben)
    while (!(TWCR & (1<<TWINT)));						// warten bis bertragung erfolgreich, Trigger ist hier das Setzen von TWINT
}
 
 
/////////////////////////////////////////
// I2C Adressbyte/Daten senden
/////////////////////////////////////////
void I2C_transmitDataOrAddress(char Data)                       
{
    TWDR = Data;										// Data Variabel in Daten Register schreiben
    TWCR = (1<<TWINT)|(1<<TWEN);						// TWEN = TWI starten (ENable), TWINT = Interrupt bit lschen (durch setzen)
    while (!(TWCR & (1<<TWINT)));						// warten bis bertragung erfolgreich, Trigger ist hier das Setzen von TWINT
}
 
/////////////////////////////////////////
// I2C Stoppbit senden
/////////////////////////////////////////
void I2C_transmitStop()
{
    TWCR=(1<<TWINT)|(1<<TWEN)|(1<<TWSTO);				// TWSTO = Stopptbit aktivieren, TWEN = TWI starten (ENable), TWINT = Interrupt bit lschen (durch setzen)
}