
// I2C-Master-Routinen von Peter Fleury verwenden
// siehe http://homepage.hispeed.ch/peterfleury/avr-software.html#libs
// Hier sind auch die Dateien: i2cmaster.h und twimaster.c zu finden, die bentigt werden
// Letztes Update des Codes 5. April 2010 durch HannoHupmann

/* define CPU frequency in hz here if not defined in Makefile */
#ifndef F_CPU
#define F_CPU 8000000UL
#endif

#define TGL_BIT(BYTE, BIT)  ((BYTE) ^=  (1 << (BIT))) // Bit Zustand in Byte wechseln (toggle)

#include <avr/io.h>
#include <avr/interrupt.h>  //dient zur Behandlung der Interrupts
#include "i2cmaster.h"
#include "uart.h"           //UART-Lib von P- Fleury
#include <util/delay.h>

#define SLAVE_ADRESSE 0x50
#define BAUD 9600 //Baudrate

uint8_t test1 = 42;
uint8_t test2 = 43;
uint8_t test3 = 44;

uint8_t byte1 = 42;
uint8_t byte2 = 43;
uint8_t byte3 = 44;

int main(void)
{
	i2c_init();         // init I2C interface
	DDRB=0xFF;

	uart_init((UART_BAUD_SELECT((BAUD),F_CPU)));
	sei();
	while(1)
	{
		//uart_puts("I2C-Test\r\n");

		if(!(i2c_start(SLAVE_ADRESSE+I2C_WRITE))) //Slave bereit zum schreiben?
		{
			i2c_write(0x00);  // Buffer Startadresse setzen
			i2c_write(test1); // Drei Bytes schreiben...
			i2c_write(test2);
			i2c_write(test3);
			i2c_stop();       // Zugriff beenden
		}
		else 
		{
			/* Hier knnte eine Fehlermeldung ausgegeben werden... */
			uart_puts("1\n"); //Leerzeile
		}



		if(!(i2c_start(SLAVE_ADRESSE+I2C_WRITE))) //Slave bereit zum lesen?
		{
			uart_puts("l\n"); //Leerzeile
			TGL_BIT(PORTB,1);
			i2c_rep_start(SLAVE_ADRESSE+I2C_READ); //Lesen beginnen
			
			byte1= i2c_readAck(); // Bytes lesen...
			byte2= i2c_readAck();
			byte3= i2c_readNak(); // letztes Byte lesen, darum kein ACK
			i2c_stop();           // Zugriff beenden
		}
		else
		{
			uart_puts("2\n"); //Leerzeile
			/* Hier knnte eine Fehlermeldung ausgegeben werden... */
		}

		if ((byte1 != test1)||(byte2 != test2)||(byte3 != test3))
		{
			/* Die Bytes wurden nicht korrekt bertragen und wieder gelesen! */
			uart_puts("3\n"); //Leerzeile
		}
	}
}

// Code wurde von HannoHupmann auf einem Mega32 getestet